#!/bin/bash

export DTR_URL=${DTR_URL:-"273226111724.dkr.ecr.us-east-1.amazonaws.com"}
export DTR_ORG=${DTR_ORG:="/images"}

unset NEXTGEN_APP_HOME
# Set NEXTGEN_APP_HOME as an absolute directory name. This approach uses the
# location of this script as the starting point and iterating over any symbolic links.
# Returns the absolute directory name of the project that contains this script.
SOURCE="${BASH_SOURCE[0]}"
while [ -h "$SOURCE" ]; do # resolve $SOURCE until the file is no longer a symlink
  NEXTGEN_APP_HOME="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
  SOURCE="$(readlink "$SOURCE")"
  [[ $SOURCE != /* ]] && SOURCE="$NEXTGEN_APP_HOME/$SOURCE" # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
done
export NEXTGEN_APP_HOME="$(dirname $( cd -P "$( dirname "$SOURCE" )" && pwd ))"

export GIT_COMMIT=$(git log -n 1 --pretty=format:'%h')